/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.actionprovider;

import com.jrockit.mc.common.Executable;
import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.common.util.IImageResource;
import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.actionprovider.IActionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;

class ActionDescriptor
implements IUserAction,
IAdaptable,
IImageResource {
    private final IConfigurationElement element;
    private final IServerHandle jvm;
    private Executable executable;
    private final Resource imageResource;

    public ActionDescriptor(IConfigurationElement element, IServerHandle jvm) {
        this.element = element;
        this.jvm = jvm;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        try {
            return "   Action= " + this.getName();
        }
        catch (Exception e) {
            return "   Action= " + this.getName() + " " + e;
        }
    }

    private synchronized Executable getExecutable() throws CoreException {
        if (this.executable == null) {
            this.executable = ((IActionFactory)this.element.createExecutableExtension("factory")).createAction(this.jvm);
        }
        return this.executable;
    }

    public void execute() throws Exception {
        this.getExecutable().execute();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IImageResource.class) {
            return this;
        }
        try {
            return AdapterUtil.getAdapter((Object)this.getExecutable(), (Class)adapter);
        }
        catch (CoreException e) {
            return null;
        }
    }

    public Resource getImageResource() {
        return this.imageResource;
    }
}

