/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.common.version.JavaVMVersionToolkit;
import com.jrockit.mc.common.version.JavaVersion;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXServiceURL;

public class ConnectionToolkit {
    private ConnectionToolkit() {
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            assert (false);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String getHostName(JMXServiceURL url) {
        if (url.getHost() == null || "".equals(url.getHost().trim())) {
            return ConnectionToolkit.deriveHost(url);
        }
        return url.getHost();
    }

    public static int getPort(JMXServiceURL url) {
        if (url.getPort() <= 0) {
            return ConnectionToolkit.derivePort(url);
        }
        return url.getPort();
    }

    private static String deriveHost(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 2) {
                st.nextToken();
                ++i;
            }
            String host = st.nextToken();
            return host;
        }
        return "unknown";
    }

    private static int derivePort(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 3) {
                st.nextToken();
                ++i;
            }
            String port = st.nextToken();
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public static JMXServiceURL createServiceURL(String host, int port) throws MalformedURLException {
        int actualPort = port != -1 ? port : 7091;
        return new JMXServiceURL("rmi", "", 0, "/jndi/rmi://" + host + ':' + actualPort + "/jmxrmi");
    }

    public static int getDefaultPort() {
        return 7091;
    }

    public static boolean isJRockit(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return JavaVMVersionToolkit.isJRockitJVMName((String)vmName);
    }

    public static boolean isHotSpot(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isHotspotJVMName((String)vmName);
    }

    public static boolean isJavaVersionAboveOrEqual(IConnectionHandle connectionHandle, JavaVersion minVersion) {
        JavaVersion version = ConnectionToolkit.getJavaVersion(connectionHandle);
        return version != null ? version.isGreaterOrEqualThan(minVersion) : true;
    }

    private static String getVMName(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return connection.getAttribute(new ObjectName("java.lang:type=Runtime"), "VmName").toString();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.INFO, "Could not check the JVM name!", e);
            return null;
        }
    }

    private static JavaVersion getJavaVersion(IConnectionHandle connectionHandle) {
        try {
            Properties serverProps = ConnectionToolkit.getServerProperties(connectionHandle);
            String javaVersion = serverProps.getProperty("java.version");
            if (javaVersion != null) {
                return new JavaVersion(javaVersion);
            }
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "System Properties from " + connectionHandle.getDescription() + " contained no java.version property!");
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not check the java.version from System Properties!", e);
        }
        return null;
    }

    public static Properties getServerProperties(IConnectionHandle connectionHandle) {
        Object props = AttributeToolkit.getAttributeValueOrNull(connectionHandle, "java.lang:type=Runtime", "SystemProperties");
        if (props instanceof TabularData) {
            return AttributeToolkit.convertMXTabularDataToMap((TabularData)props);
        }
        return new Properties();
    }
}

