/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Arrays;
import java.util.Map;

class LongHashMap {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient long[] table;
    private int size;
    private transient int modCount;
    private transient int threshold;

    LongHashMap() {
        this.init(32);
    }

    LongHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2;
        int n3 = 4 * n / 3;
        if (n3 > 0x20000000 || n3 < 0) {
            n2 = 0x20000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private void init(int n) {
        assert ((n & -n) == n);
        assert (n >= 4);
        assert (n <= 0x20000000);
        this.threshold = n * 3 / 4;
        this.table = new long[2 * n];
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(long l, int n) {
        int n2 = (int)(l ^ l >>> 32);
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        n2 ^= n2 >>> 7 ^ n2 >>> 4;
        return n2 & n - 2;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 2 < n2 ? n + 2 : 0;
    }

    long get(long l) {
        long l2 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l2, n);
        long l3;
        while ((l3 = lArray[n2]) != l2) {
            if (l3 == 0L) {
                return 0L;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
        return lArray[n2 + 1];
    }

    boolean containsKey(long l) {
        long l2 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l2, n);
        long l3;
        while ((l3 = lArray[n2]) != l2) {
            if (l3 == 0L) {
                return false;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
        return true;
    }

    boolean containsValue(long l) {
        long[] lArray = this.table;
        for (int i = 1; i < lArray.length; i += 2) {
            if (lArray[i] != l || lArray[i - 1] == 0L) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(long l, long l2) {
        long l3 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l3, n);
        long l4;
        while ((l4 = lArray[n2]) != l3) {
            if (l4 == 0L) {
                return false;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
        return lArray[n2 + 1] == l2;
    }

    long put(long l, long l2) {
        long l3;
        assert (l != 0L);
        long l4 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l4, n);
        while ((l3 = lArray[n2]) != 0L) {
            if (l3 == l4) {
                long l5 = lArray[n2 + 1];
                lArray[n2 + 1] = l2;
                return l5;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
        ++this.modCount;
        lArray[n2] = l4;
        lArray[n2 + 1] = l2;
        if (++this.size >= this.threshold) {
            this.resize(n);
        }
        return 0L;
    }

    private void resize(int n) {
        int n2 = n * 2;
        long[] lArray = this.table;
        int n3 = lArray.length;
        if (n3 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n3 >= n2) {
            return;
        }
        long[] lArray2 = new long[n2];
        this.threshold = n * 3 / 4;
        for (int i = 0; i < n3; i += 2) {
            long l = lArray[i];
            if (l == 0L) continue;
            long l2 = lArray[i + 1];
            int n4 = LongHashMap.hash(l, n2);
            while (lArray2[n4] != 0L) {
                n4 = LongHashMap.nextKeyIndex(n4, n2);
            }
            lArray2[n4] = l;
            lArray2[n4 + 1] = l2;
        }
        this.table = lArray2;
    }

    void putAll(Map<Long, Long> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    long remove(long l) {
        long l2 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l2, n);
        while (true) {
            long l3;
            if ((l3 = lArray[n2]) == l2) {
                ++this.modCount;
                --this.size;
                long l4 = lArray[n2 + 1];
                lArray[n2 + 1] = 0L;
                lArray[n2] = 0L;
                this.closeDeletion(n2);
                return l4;
            }
            if (l3 == 0L) {
                return -1L;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
    }

    private boolean removeMapping(long l, long l2) {
        long l3 = l;
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongHashMap.hash(l3, n);
        while (true) {
            long l4;
            if ((l4 = lArray[n2]) == l3) {
                if (lArray[n2 + 1] != l2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                lArray[n2] = 0L;
                lArray[n2 + 1] = 0L;
                this.closeDeletion(n2);
                return true;
            }
            if (l4 == 0L) {
                return false;
            }
            n2 = LongHashMap.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        long l;
        long[] lArray = this.table;
        int n2 = lArray.length;
        int n3 = LongHashMap.nextKeyIndex(n, n2);
        while ((l = lArray[n3]) != 0L) {
            int n4 = LongHashMap.hash(l, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                lArray[n] = l;
                lArray[n + 1] = lArray[n3 + 1];
                lArray[n3] = 0L;
                lArray[n3 + 1] = 0L;
                n = n3;
            }
            n3 = LongHashMap.nextKeyIndex(n3, n2);
        }
    }

    void clear() {
        ++this.modCount;
        long[] lArray = this.table;
        Arrays.fill(lArray, 0L);
        this.size = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LongHashMap) {
            LongHashMap longHashMap = (LongHashMap)object;
            if (longHashMap.size() != this.size) {
                return false;
            }
            long[] lArray = longHashMap.table;
            for (int i = 0; i < lArray.length; i += 2) {
                long l = lArray[i];
                if (l == 0L || this.containsMapping(l, lArray[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        long[] lArray = this.table;
        for (int i = 0; i < lArray.length; i += 2) {
            long l = lArray[i];
            if (l == 0L) continue;
            long l2 = l;
            n += LongHashMap.hash(l2, lArray.length) ^ LongHashMap.hash(lArray[i + 1], lArray.length);
        }
        return n;
    }
}

