/*
 * Decompiled with CFR 0.152.
 */
package edu.umons.kafka.helper;

import java.util.List;
import org.apache.commons.math3.util.Precision;

public class AppMathUtils {
    private AppMathUtils() {
    }

    public static Double sum(List<Double> values) {
        Double sumVal = 0.0;
        if (values == null || values.isEmpty()) {
            return sumVal;
        }
        for (Double val : values) {
            sumVal = sumVal + val;
        }
        return sumVal;
    }

    public static Double average(List<Double> values) {
        Double averageVal = 0.0;
        if (values == null || values.isEmpty()) {
            return averageVal;
        }
        averageVal = AppMathUtils.sum(values) / (double)values.size();
        return averageVal;
    }

    public static Double average(List<Double> values, int precisionVal) {
        return Precision.round(AppMathUtils.average(values), precisionVal);
    }

    public static Double sumSqr(List<Double> values, Double averageVal) {
        Double sumSqrVal = 0.0;
        if (values == null || values.isEmpty()) {
            return sumSqrVal;
        }
        for (Double val : values) {
            sumSqrVal = sumSqrVal + Math.pow(Math.abs(val - averageVal), 2.0);
        }
        return sumSqrVal;
    }

    public static Double variance(List<Double> values, Double averageVal) {
        Double varianceVal = 0.0;
        if (values == null || values.isEmpty()) {
            return varianceVal;
        }
        varianceVal = AppMathUtils.sumSqr(values, averageVal) / (double)values.size();
        return varianceVal;
    }

    public static Double variance(List<Double> values, Double averageVal, int precisionVal) {
        return Precision.round(AppMathUtils.variance(values, averageVal), precisionVal);
    }

    public static Double standardDeviation(Double varianceVal) {
        return Math.sqrt(varianceVal);
    }

    public static Double standardDeviation(Double varianceVal, int precisionVal) {
        return Precision.round(AppMathUtils.standardDeviation(varianceVal), precisionVal);
    }
}

