/*
 * Decompiled with CFR 0.152.
 */
package edu.umons.kafka;

import edu.umons.kafka.DataObject;
import edu.umons.kafka.IKafkaConstants;
import edu.umons.kafka.ProducerCreator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class App {
    private static final Logger LOGGER = Logger.getLogger(App.class.getName());

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        App.runProducer();
    }

    private static void runProducer() throws InterruptedException, ExecutionException {
        Producer<Long, DataObject> producer = ProducerCreator.createProducer();
        for (int index = 0; index < IKafkaConstants.MESSAGE_COUNT; ++index) {
            DataObject dataObject = new DataObject();
            dataObject.setId(index);
            dataObject.setName("Record_" + index);
            ProducerRecord record = new ProducerRecord("cow-datas-topic", dataObject);
            try {
                RecordMetadata metadata = producer.send(record).get();
                LOGGER.info("Record sent with key " + index + " to partition " + metadata.partition() + "with offset " + metadata.offset());
                System.out.println("Record sent with key " + index + " to partition " + metadata.partition() + "with offset " + metadata.offset());
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.log(Level.SEVERE, "Error in sending record", e);
                throw e;
            }
        }
    }
}

